#!/bin/bash

set -x

nstep=$1

# params for grain_growth_1024
# lshK=5
# lshL=3
# lshr=0.8

lshK=10
lshL=3
lshr=0.8

python_folder=../python_simulation

#grain_growth_input=output/grain_growth_n64_init3.in
#grain_growth_input=output/grain_growth_n1024_init3.in
# grain_growth_input=output/grain_growth_n4096_init3.in
grain_growth_input=../data_128
chash_output=output/grain_growth_n4096_chash_ns${nstep}_K${lshK}_L${lshL}_r${lshr}.out
bucket_output=output/grain_growth_n4096_chash_bucket_ns${nstep}_K${lshK}_L${lshL}_r${lshr}.out

python_output=output/python_grain_growth_n4096_exact_ns${nstep}.out

## run 
rm log_gg_1
rm log_gg_t_1

make gg_test
./gg_test --nsteps $nstep --lshK $lshK --lshL $lshL --lshr $lshr --input $grain_growth_input --output $chash_output --bucket_output $bucket_output > log_gg_1 &

make gg_torch
./gg_torch --nsteps $nstep --lshK $lshK --lshL $lshL --lshr $lshr --input $grain_growth_input --output $chash_output --bucket_output $bucket_output > log_gg_t_1 &
